/*
 * Decompiled with CFR 0.152.
 */
package org.bolet.jgz;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bolet.jgz.Adler32;
import org.bolet.jgz.Deflater;

public class ZlibOutputStream
extends OutputStream {
    private OutputStream out;
    private Deflater deflater;
    private byte[] oneByte;
    private Adler32 adler;
    private int level;
    private boolean hasDictionary;
    private int dictID;
    private boolean headerWritten;

    public ZlibOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 3);
    }

    public ZlibOutputStream(OutputStream outputStream, int n) throws IOException {
        this.out = outputStream;
        this.level = n;
        this.deflater = new Deflater(n);
        this.deflater.setOut(outputStream);
        this.oneByte = new byte[1];
        this.adler = new Adler32();
    }

    public void processDictionary(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        Adler32 adler32 = new Adler32();
        while ((n = inputStream.read(byArray)) >= 0) {
            this.deflater.processDictionary(byArray, 0, n);
            adler32.update(byArray, 0, n);
        }
        this.hasDictionary = true;
        this.dictID = adler32.getSum();
    }

    public void processDictionary(byte[] byArray) {
        this.processDictionary(byArray, 0, byArray.length);
    }

    public void processDictionary(byte[] byArray, int n, int n2) {
        this.deflater.processDictionary(byArray, n, n2);
        this.hasDictionary = true;
        Adler32 adler32 = new Adler32();
        adler32.update(byArray, n, n2);
        this.dictID = adler32.getSum();
    }

    private void writes4(int n) throws IOException {
        this.out.write(n >>> 24);
        this.out.write(n >>> 16);
        this.out.write(n >>> 8);
        this.out.write(n);
    }

    private void writeHeader() throws IOException {
        int n;
        int n2;
        if (this.headerWritten) {
            return;
        }
        int n3 = 120;
        switch (this.level) {
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
            default: {
                n2 = 2;
            }
        }
        n2 <<= 6;
        if (this.hasDictionary) {
            n2 |= 0x20;
        }
        if ((n = (n3 << 8 | n2) % 31) > 0) {
            n2 += 31 - n;
        }
        this.out.write(n3);
        this.out.write(n2);
        if (this.hasDictionary) {
            this.writes4(this.dictID);
        }
        this.headerWritten = true;
    }

    public void close() throws IOException {
        this.terminate();
        this.out.close();
    }

    public void terminate() throws IOException {
        this.writeHeader();
        this.deflater.terminate();
        this.writes4(this.adler.getSum());
    }

    public void flush() throws IOException {
        this.flushSync(true);
    }

    public void flushSync(boolean bl) throws IOException {
        this.writeHeader();
        this.deflater.flushSync(bl);
        this.deflater.getOut().flush();
    }

    public void flushFull(boolean bl) throws IOException {
        this.writeHeader();
        this.deflater.flushFull(bl);
        this.deflater.getOut().flush();
    }

    public void flushPartial() throws IOException {
        this.writeHeader();
        this.deflater.flushPartial();
        this.deflater.getOut().flush();
    }

    public void write(int n) throws IOException {
        this.oneByte[0] = (byte)n;
        this.write(this.oneByte, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.writeHeader();
        this.deflater.process(byArray, n, n2);
        this.adler.update(byArray, n, n2);
    }
}

